
//-----------Document ready----------

jQuery(document).ready(function() {
		
	if(jQuery('#backgroundColorSelector').length == 0) {
		return false;	
	}
	
	jQuery("select, input:text, input:file, input:checkbox").uniform();
	
	//colorpicker for the background color
	jQuery('#backgroundColorSelector').ColorPicker({ color: colorToHex(jQuery('#backgroundColorSelector div').css('backgroundColor')),
		onShow: function (colpkr) {
			jQuery(colpkr).fadeIn(500);
			return false;
		},
		onHide: function (colpkr) {
			jQuery(colpkr).fadeOut(500);
			return false;
		},
		onSubmit: function (hsb, hex, rgb, el) {
			jQuery('#backgroundColorSelector div').css('backgroundColor', '#' + hex);
			jQuery('#backgroundColor').val('#' + hex);
			jQuery(el).ColorPickerHide();
		}
	});
	
	//colorpicker for the title color
	jQuery('#titleColorSelector').ColorPicker({ color: colorToHex(jQuery('#titleColorSelector div').css('backgroundColor')),
		onShow: function (colpkr) {
			jQuery(colpkr).fadeIn(500);
			return false;
		},
		onHide: function (colpkr) {
			jQuery(colpkr).fadeOut(500);
			return false;
		},
		onSubmit: function (hsb, hex, rgb, el) {
			jQuery('#titleColorSelector div').css('backgroundColor', '#' + hex);
			jQuery('#titleColor').val('#' + hex);
			jQuery(el).ColorPickerHide();
		}
	});
	
	//set shadow image
	jQuery('#uploadShadowImage').parent().find('.filename').text(jQuery("input[name='shadow_image']").val() == '' ? 'No file selected': jQuery("input[name='shadow_image']").val());	
    jQuery('#uploadShadowImage').click(function(evt) {
		tb_show('', 'media-upload.php?type=image&amp;TB_iframe=true');	
		 window.send_to_editor = function(html) {
			imagePath = jQuery('img',html).attr('src');
			jQuery("input[name='shadow_image']").val(imagePath);
			jQuery('#uploadShadowImage').parent().find('.filename').text(imagePath);		
			tb_remove();
		}
		return false;
	});
	
	jQuery('#removeShadow').click(function(evt) {
		jQuery('#uploadShadowImage').val('');
		jQuery("input[name='shadow_image']").val('');
		jQuery('#uploadShadowImage').parent().find('.filename').text('No file selected')
		return false;
	});
	
});

function colorToHex(color) {
    if (color.substr(0, 1) === '#') {
        return color;
    }
    var digits = /(.*?)rgb\((\d+), (\d+), (\d+)\)/.exec(color);
    
    var red = parseInt(digits[2]);
    var green = parseInt(digits[3]);
    var blue = parseInt(digits[4]);
    
    var rgb = blue | (green << 8) | (red << 16);
    return digits[1] + '#' + rgb.toString(16);
};